/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.sequence;

import icyllis.annotations.NotNull;
import icyllis.annotations.Nullable;
import icyllis.flexmark.util.sequence.IRichSequenceBase;
import icyllis.flexmark.util.sequence.MappedRichSequence;
import icyllis.flexmark.util.sequence.RichSequence;
import icyllis.flexmark.util.sequence.SequenceUtils;
import icyllis.flexmark.util.sequence.builder.ISequenceBuilder;
import icyllis.flexmark.util.sequence.builder.RichSequenceBuilder;
import icyllis.flexmark.util.sequence.mappers.CharMapper;

public class RichSequenceImpl
extends IRichSequenceBase<RichSequence>
implements RichSequence {
    final CharSequence charSequence;

    private RichSequenceImpl(CharSequence charSequence) {
        super(charSequence instanceof String ? charSequence.hashCode() : 0);
        this.charSequence = charSequence;
    }

    @NotNull
    public RichSequence[] emptyArray() {
        return EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public RichSequence nullSequence() {
        return NULL;
    }

    @Override
    @NotNull
    public RichSequence sequenceOf(@Nullable CharSequence charSequence, int startIndex, int endIndex) {
        return RichSequenceImpl.of(charSequence, startIndex, endIndex);
    }

    @Override
    @NotNull
    public <B extends ISequenceBuilder<B, RichSequence>> B getBuilder() {
        return (B)RichSequenceBuilder.emptyBuilder();
    }

    @Override
    @NotNull
    public RichSequence subSequence(int startIndex, int endIndex) {
        SequenceUtils.validateStartEnd(startIndex, endIndex, this.length());
        if (startIndex == 0 && endIndex == this.charSequence.length()) {
            return this;
        }
        return RichSequenceImpl.create(this.charSequence, startIndex, endIndex);
    }

    @Override
    public int length() {
        return this.charSequence.length();
    }

    @Override
    public char charAt(int index) {
        char c = this.charSequence.charAt(index);
        return c == '\u0000' ? (char)'\ufffd' : (char)c;
    }

    @Override
    @NotNull
    public RichSequence toMapped(CharMapper mapper) {
        return MappedRichSequence.mappedOf(mapper, this);
    }

    static RichSequence create(CharSequence charSequence, int startIndex, int endIndex) {
        if (charSequence instanceof RichSequence) {
            return (RichSequence)((RichSequence)charSequence).subSequence(startIndex, endIndex);
        }
        if (charSequence != null) {
            if (startIndex == 0 && endIndex == charSequence.length()) {
                return new RichSequenceImpl(charSequence);
            }
            return new RichSequenceImpl(charSequence.subSequence(startIndex, endIndex));
        }
        return NULL;
    }

    @Deprecated
    public static RichSequence of(CharSequence charSequence) {
        return RichSequence.of(charSequence, 0, charSequence.length());
    }

    @Deprecated
    public static RichSequence of(CharSequence charSequence, int startIndex) {
        return RichSequence.of(charSequence, startIndex, charSequence.length());
    }

    @Deprecated
    public static RichSequence of(CharSequence charSequence, int startIndex, int endIndex) {
        return RichSequence.of(charSequence, startIndex, endIndex);
    }
}

